/// <reference path="./internal_*.d.ts" />
declare namespace net.minecraft.world.level.levelgen.blockpredicates {
    interface BlockPredicate extends Internal.BiPredicate<Internal.WorldGenLevel, BlockPos> {
        hasSturdyFace($$0: Internal.Direction_): this;
        noFluid($$0: Vec3i_): this;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): this;
        anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): this;
        noFluid(): this;
        anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): this;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        abstract test(arg0: Internal.WorldGenLevel_, arg1: BlockPos_): boolean;
        solid($$0: Vec3i_): this;
        insideWorld($$0: Vec3i_): this;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        matchesTag($$0: Internal.TagKey_<Internal.Block>): this;
        solid(): this;
        alwaysTrue(): this;
        matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): this;
        abstract type(): Internal.BlockPredicateType<any>;
        matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): this;
        allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): this;
        replaceable(): this;
        wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): this;
        matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): this;
        not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): this;
        matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): this;
        allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): this;
        allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): this;
        anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): this;
        replaceable($$0: Vec3i_): this;
        hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): this;
        matchesBlocks(...$$0: Internal.Block_[]): this;
        matchesBlocks($$0: Internal.List_<Internal.Block>): this;
        matchesFluids(...$$0: Internal.Fluid_[]): this;
        readonly CODEC: Internal.Codec<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>;
        readonly ONLY_IN_AIR_PREDICATE: Internal.MatchingBlocksPredicate;
        readonly ONLY_IN_AIR_OR_WATER_PREDICATE: Internal.MatchingBlocksPredicate;
    }
    type BlockPredicate_ = BlockPredicate;
}
declare namespace Internal {
    interface IGridLinkableHandler {
        abstract canLink(arg0: Internal.ItemStack_): boolean;
        abstract unlink(arg0: Internal.ItemStack_): void;
        abstract link(arg0: Internal.ItemStack_, arg1: Internal.GlobalPos_): void;
    }
    type IGridLinkableHandler_ = IGridLinkableHandler;
    class EnchantmentTableBlockEntity extends Internal.BlockEntity implements Internal.Nameable {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        getName(): net.minecraft.network.chat.Component;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        static bookAnimationTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.EnchantmentTableBlockEntity_): void;
        setCustomName($$0: net.minecraft.network.chat.Component_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        hasCustomName(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getCustomName(): net.minecraft.network.chat.Component;
        get displayName(): net.minecraft.network.chat.Component
        get name(): net.minecraft.network.chat.Component
        set customName($$0: net.minecraft.network.chat.Component_)
        get customName(): net.minecraft.network.chat.Component
        rot: number;
        tRot: number;
        open: number;
        flipT: number;
        oOpen: number;
        time: number;
        oFlip: number;
        oRot: number;
        flipA: number;
        flip: number;
    }
    type EnchantmentTableBlockEntity_ = EnchantmentTableBlockEntity;
    class Gui implements Internal.GuiAccessor, com.simibubi.create.foundation.mixin.accessor.GuiAccessor, com.simibubi.create.foundation.mixin.fabric.GuiAccessor {
        constructor($$0: Internal.Minecraft_, $$1: Internal.ItemRenderer_)
        porting_lib$screenHeight(): number;
        handler$cpo000$ftbchunks$onRenderEffectsReturn(guiGraphics: Internal.GuiGraphics_, info: Internal.CallbackInfo_): void;
        renderSelectedItemName($$0: Internal.GuiGraphics_): void;
        setTimes($$0: number, $$1: number, $$2: number): void;
        handler$bem000$balm$renderPlayerHealthPre(guiGraphics: Internal.GuiGraphics_, callbackInfo: Internal.CallbackInfo_): void;
        getBossOverlay(): Internal.BossHealthOverlay;
        handler$zfb000$porting_lib_base$port_lib$render(matrixStack: Internal.GuiGraphics_, f: number, ci: Internal.CallbackInfo_): void;
        porting_lib$screenWidth(): number;
        "handler$cka000$fabric-rendering-v1$render"(drawContext: Internal.GuiGraphics_, tickDelta: number, callbackInfo: Internal.CallbackInfo_): void;
        handler$bem000$balm$renderAllPre(guiGraphics: Internal.GuiGraphics_, partialTicks: number, callbackInfo: Internal.CallbackInfo_): void;
        setSubtitle($$0: net.minecraft.network.chat.Component_): void;
        handler$dap000$glitchcore$onRender(guiGraphics: Internal.GuiGraphics_, partialTicks: number, ci: Internal.CallbackInfo_): void;
        renderDemoOverlay($$0: Internal.GuiGraphics_): void;
        setOverlayMessage($$0: net.minecraft.network.chat.Component_, $$1: boolean): void;
        onDisconnected(): void;
        isShowingChatDisabledByPlayer(): boolean;
        getChat(): Internal.ChatComponent;
        getToolHighlightTimer(): number;
        clearCache(): void;
        porting_lib$canRenderCrosshairForSpectator(arg0: Internal.HitResult_): boolean;
        handler$dlh000$iris$handleHudHidingScreens(pGui0: Internal.GuiGraphics_, pFloat1: number, ci: Internal.CallbackInfo_): void;
        handler$bem000$balm$renderPlayerHealthPost(guiGraphics: Internal.GuiGraphics_, callbackInfo: Internal.CallbackInfo_): void;
        renderExperienceBar($$0: Internal.GuiGraphics_, $$1: number): void;
        render($$0: Internal.GuiGraphics_, $$1: number): void;
        getSpectatorGui(): Internal.SpectatorGui;
        renderJumpMeter($$0: Internal.PlayerRideableJumping_, $$1: Internal.GuiGraphics_, $$2: number): void;
        getFont(): net.minecraft.client.gui.Font;
        getGuiTicks(): number;
        setNowPlaying($$0: net.minecraft.network.chat.Component_): void;
        setTitle($$0: net.minecraft.network.chat.Component_): void;
        clear(): void;
        tick($$0: boolean): void;
        resetTitleTimes(): void;
        setChatDisabledByPlayerShown($$0: boolean): void;
        create$getSubtitleOverlay(): Internal.SubtitleOverlay;
        getTabList(): Internal.PlayerTabOverlay;
        handler$bem000$balm$renderAllPost(guiGraphics: Internal.GuiGraphics_, partialTicks: number, callbackInfo: Internal.CallbackInfo_): void;
        handler$cpo000$ftbchunks$onRenderEffectsEnter(guiGraphics: Internal.GuiGraphics_, info: Internal.CallbackInfo_): void;
        get bossOverlay(): Internal.BossHealthOverlay
        set subtitle($$0: net.minecraft.network.chat.Component_)
        get showingChatDisabledByPlayer(): boolean
        get chat(): Internal.ChatComponent
        get toolHighlightTimer(): number
        get spectatorGui(): Internal.SpectatorGui
        get font(): net.minecraft.client.gui.Font
        get guiTicks(): number
        set nowPlaying($$0: net.minecraft.network.chat.Component_)
        set title($$0: net.minecraft.network.chat.Component_)
        set chatDisabledByPlayerShown($$0: boolean)
        get tabList(): Internal.PlayerTabOverlay
        static readonly GUI_ICONS_LOCATION: ResourceLocation;
        vignetteBrightness: number;
    }
    type Gui_ = Gui;
    class DigDurabilityEnchantment extends Internal.Enchantment {
        handler$zlb000$ae2$enchantPlane(stack: Internal.ItemStack_, cir: Internal.CallbackInfoReturnable_<any>): void;
        static shouldIgnoreDurabilityDrop($$0: Internal.ItemStack_, $$1: number, $$2: Internal.RandomSource_): boolean;
    }
    type DigDurabilityEnchantment_ = DigDurabilityEnchantment;
    interface LevelSimulatedReader {
        abstract getHeightmapPos(arg0: Internal.Heightmap$Types_, arg1: BlockPos_): BlockPos;
        abstract isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        abstract isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        abstract getBlockEntity<T extends Internal.BlockEntity>(arg0: BlockPos_, arg1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
    }
    type LevelSimulatedReader_ = LevelSimulatedReader;
    class MetalLadderBlock extends Internal.LadderBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(p_54345_: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MetalLadderBlock_ = MetalLadderBlock;
    class LargeFireball extends Internal.Fireball {
        constructor($$0: Internal.EntityType_<Internal.LargeFireball>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number, $$5: number)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type LargeFireball_ = LargeFireball;
    class ElectricMotorBlockEntity extends Internal.GeneratingKineticBlockEntity implements Internal.EnergyTransferable {
        constructor(type: Internal.BlockEntityType_<Internal.ElectricMotorBlockEntity>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getEnergyStorage(): Internal.InternalEnergyStorage;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getEnergyStorage(side: Internal.Direction_): Internal.EnergyStorage;
        updateGeneratedRotation(i: number): void;
        getRPM(): number;
        static getDurationDistance(dis: number, initialProgress: number, speed: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        read(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        static step(context: Internal.ScrollValueBehaviour$StepContext_): number;
        onLoad(): void;
        getEnergyConsumption(): number;
        isEnergyOutput(side: Internal.Direction_): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        isPoweredState(): boolean;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        setRPM(rpm: number): boolean;
        invalidateCaps(): void;
        static getEnergyConsumptionRate(rpm: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isEnergyInput(side: Internal.Direction_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getGeneratedStress(): number;
        static getDurationAngle(deg: number, initialProgress: number, speed: number): number;
        getRenderBoundingBox(): Internal.AABB;
        get energyStorage(): Internal.InternalEnergyStorage
        get RPM(): number
        get energyConsumption(): number
        get poweredState(): boolean
        set RPM(rpm: number)
        get infiniteBoundingBox(): Internal.AABB
        get generatedStress(): number
        get renderBoundingBox(): Internal.AABB
    }
    type ElectricMotorBlockEntity_ = ElectricMotorBlockEntity;
    class TeamPropertyType <T> {
        static read(buf: Internal.FriendlyByteBuf_): Internal.TeamProperty<any>;
        static write(buf: Internal.FriendlyByteBuf_, p: Internal.TeamProperty_<any>): void;
        static readonly STRING_LIST: Internal.TeamPropertyType<Internal.List<string>>;
        static readonly BOOLEAN: Internal.TeamPropertyType<boolean>;
        static readonly DOUBLE: Internal.TeamPropertyType<number>;
        static readonly COLOR: Internal.TeamPropertyType<Internal.Color4I>;
        static readonly ENUM: Internal.TeamPropertyType<string>;
        static readonly STRING: Internal.TeamPropertyType<string>;
        static readonly INT: Internal.TeamPropertyType<number>;
        static readonly PRIVACY_MODE: Internal.TeamPropertyType<Internal.PrivacyMode>;
    }
    type TeamPropertyType_<T> = TeamPropertyType<T>;
    abstract class BOPTreeFeature <FC extends Internal.BOPTreeConfiguration> extends Internal.TreeFeature {
        setTrunkFruit(level: Internal.LevelAccessor_, pos: BlockPos_, config: FC): boolean;
        static isFree(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
        placeLog(world: Internal.LevelAccessor_, pos: BlockPos_, logs: Internal.BiConsumer_<BlockPos, Internal.BlockState>, config: FC): boolean;
        placeAltLeaves(level: Internal.LevelAccessor_, pos: BlockPos_, leaves: Internal.FoliagePlacer$FoliageSetter_, config: FC): boolean;
        placeLeaves(level: Internal.LevelAccessor_, pos: BlockPos_, leaves: Internal.FoliagePlacer$FoliageSetter_, config: FC): boolean;
        placeLog(level: Internal.LevelAccessor_, pos: BlockPos_, axis: Internal.Direction$Axis_, logs: Internal.BiConsumer_<BlockPos, Internal.BlockState>, config: FC): boolean;
        setVine(world: Internal.LevelAccessor_, rand: Internal.RandomSource_, pos: BlockPos_, side: Internal.Direction_, length: number, config: FC): boolean;
        setHanging(level: Internal.LevelAccessor_, pos: BlockPos_, config: FC): boolean;
    }
    type BOPTreeFeature_<FC extends Internal.BOPTreeConfiguration> = BOPTreeFeature<FC>;
    interface IControlContraption {
        abstract attach(arg0: Internal.ControlledContraptionEntity_): void;
        abstract isValid(): boolean;
        abstract onStall(): void;
        abstract getBlockPosition(): BlockPos;
        abstract isAttachedTo(arg0: Internal.AbstractContraptionEntity_): boolean;
        get valid(): boolean
        get blockPosition(): BlockPos
    }
    type IControlContraption_ = IControlContraption;
    class CellState extends Internal.Enum<Internal.CellState> {
        static valueOf(name: string): Internal.CellState;
        getStateColor(): number;
        static values(): Internal.CellState[];
        get stateColor(): number
        static readonly TYPES_FULL: Internal.CellState;
        static readonly EMPTY: Internal.CellState;
        static readonly FULL: Internal.CellState;
        static readonly ABSENT: Internal.CellState;
        static readonly NOT_EMPTY: Internal.CellState;
    }
    type CellState_ = "not_empty" | "absent" | "empty" | "types_full" | "full" | CellState;
    class PlacementPatterns extends Internal.Enum<Internal.PlacementPatterns> {
        static values(): Internal.PlacementPatterns[];
        static valueOf(name: string): Internal.PlacementPatterns;
        static applyPattern(blocksIn: Internal.List_<BlockPos>, stack: Internal.ItemStack_): void;
        static readonly InverseCheckered: Internal.PlacementPatterns;
        static readonly Chance50: Internal.PlacementPatterns;
        static readonly Checkered: Internal.PlacementPatterns;
        readonly translationKey: string;
        static readonly Chance25: Internal.PlacementPatterns;
        readonly icon: Internal.AllIcons;
        static readonly Chance75: Internal.PlacementPatterns;
        static readonly Solid: Internal.PlacementPatterns;
    }
    type PlacementPatterns_ = "inversecheckered" | "chance50" | "solid" | "chance75" | "chance25" | PlacementPatterns | "checkered";
    /**
     * Invoked when a player gets an advancement.
    */
    class PlayerAdvancementEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.ServerPlayer_, advancement: Internal.Advancement_)
        /**
         * Returns the advancement that was obtained.
        */
        getAdvancement(): Internal.AdvancementJS;
        /**
         * Returns the advancement that was obtained.
        */
        get advancement(): Internal.AdvancementJS
    }
    type PlayerAdvancementEventJS_ = PlayerAdvancementEventJS;
    class Collector$Characteristics extends Internal.Enum<Internal.Collector$Characteristics> {
        static values(): Internal.Collector$Characteristics[];
        static valueOf(arg0: string): Internal.Collector$Characteristics;
        static readonly CONCURRENT: Internal.Collector$Characteristics;
        static readonly IDENTITY_FINISH: Internal.Collector$Characteristics;
        static readonly UNORDERED: Internal.Collector$Characteristics;
    }
    type Collector$Characteristics_ = Collector$Characteristics | "identity_finish" | "unordered" | "concurrent";
    class SpriteContents$Ticker implements Internal.SpriteTicker, Internal.SpriteContentsTickerAccessor, Internal.SpriteContentsAnimatorImplAccessor {
        getAnimationInfo(): Internal.SpriteContents$AnimatedTexture;
        handler$hfj000$sodium$assignParent(spriteContents: Internal.SpriteContents_, animation: Internal.SpriteContents$AnimatedTexture_, interpolation: Internal.SpriteContents$InterpolationData_, ci: Internal.CallbackInfo_): void;
        setFrame(arg0: number): void;
        getField_40546(): Internal.SpriteContents$AnimatedTexture;
        getFrameTicks(): number;
        close(): void;
        getFrameIndex(): number;
        setSubFrame(arg0: number): void;
        getFrame(): number;
        getSubFrame(): number;
        tickAndUpload($$0: number, $$1: number): void;
        get animationInfo(): Internal.SpriteContents$AnimatedTexture
        set frame(arg0: number)
        get field_40546(): Internal.SpriteContents$AnimatedTexture
        get frameTicks(): number
        get frameIndex(): number
        set subFrame(arg0: number)
        get frame(): number
        get subFrame(): number
    }
    type SpriteContents$Ticker_ = SpriteContents$Ticker;
    interface Display$FloatInterpolator {
        abstract get(arg0: number): number;
        constant($$0: number): this;
        (arg0: number): number;
    }
    type Display$FloatInterpolator_ = Display$FloatInterpolator;
    class Provider$Service {
        constructor(arg0: Internal.Provider_, arg1: string, arg2: string, arg3: string, arg4: Internal.List_<string>, arg5: Internal.Map_<string, string>)
        newInstance(arg0: any): any;
        getAlgorithm(): string;
        getAttribute(arg0: string): string;
        getType(): string;
        getClassName(): string;
        supportsParameter(arg0: any): boolean;
        getProvider(): Internal.Provider;
        get algorithm(): string
        get type(): string
        get className(): string
        get provider(): Internal.Provider
    }
    type Provider$Service_ = Provider$Service;
    class MillstoneBlockEntity extends Internal.KineticBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getProcessingSpeed(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getItemStorage(direction: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        spawnParticles(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get processingSpeed(): number
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        inputInv: Internal.ItemStackHandlerContainer;
        timer: number;
        capability: Internal.MillstoneBlockEntity$MillstoneInventoryHandler;
        outputInv: io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
    }
    type MillstoneBlockEntity_ = MillstoneBlockEntity;
    class NoiseSettings extends Internal.Record {
        constructor($$0: number, $$1: number, $$2: number, $$3: number)
        getCellHeight(): number;
        noiseSizeVertical(): number;
        clampToHeightAccessor($$0: Internal.LevelHeightAccessor_): this;
        static create($$0: number, $$1: number, $$2: number, $$3: number): Internal.NoiseSettings;
        getCellWidth(): number;
        noiseSizeHorizontal(): number;
        height(): number;
        minY(): number;
        get cellHeight(): number
        get cellWidth(): number
        static readonly CODEC: Internal.Codec<Internal.NoiseSettings>;
    }
    type NoiseSettings_ = NoiseSettings;
    class ListFilterItem extends Internal.FilterItem {
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getFilterItemHandler(stack: Internal.ItemStack_): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
        canCopyFromItem(item: Internal.ItemStack_): boolean;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        shouldCloseCurrentScreen(): boolean;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        canCopyToItem(item: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        createCopy(original: Internal.ItemStack_, count: number): Internal.ItemStack;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ListFilterItem_ = ListFilterItem;
    class LevelResource implements Internal.SpectreLibMixinLevelResource, Internal.LevelResourceAccessor {
        constructor($$0: string)
        static spectrelib$create(id: string): Internal.LevelResource;
        static forgeconfigapiport$create(string: string): Internal.LevelResource;
        static create$forgeconfigapiport_$md$fca01f$0(arg0: string): Internal.LevelResource;
        static create$spectrelib_$md$fca01f$1(arg0: string): Internal.LevelResource;
        getId(): string;
        get id(): string
        static readonly PLAYER_OLD_DATA_DIR: Internal.LevelResource;
        static readonly OLD_LEVEL_DATA_FILE: Internal.LevelResource;
        static readonly PLAYER_STATS_DIR: Internal.LevelResource;
        static readonly ROOT: Internal.LevelResource;
        static readonly MAP_RESOURCE_FILE: Internal.LevelResource;
        static readonly GENERATED_DIR: Internal.LevelResource;
        static readonly LOCK_FILE: Internal.LevelResource;
        static readonly LEVEL_DATA_FILE: Internal.LevelResource;
        static readonly ICON_FILE: Internal.LevelResource;
        static readonly PLAYER_ADVANCEMENTS_DIR: Internal.LevelResource;
        static readonly PLAYER_DATA_DIR: Internal.LevelResource;
        static readonly DATAPACK_DIR: Internal.LevelResource;
    }
    type LevelResource_ = LevelResource;
    class AllArmInteractionPointTypes$BlazeBurnerType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$BlazeBurnerType_ = AllArmInteractionPointTypes$BlazeBurnerType;
    class ClientChunkCache extends Internal.ChunkSource {
        constructor($$0: Internal.ClientLevel_, $$1: number)
        handler$haf000$railways$securitycraft$onUpdateViewRadius(viewDistance: number, ci: Internal.CallbackInfo_): void;
        replaceBiomes($$0: number, $$1: number, $$2: Internal.FriendlyByteBuf_): void;
        drop($$0: number, $$1: number): void;
        updateViewCenter($$0: number, $$1: number): void;
        handler$haf000$railways$securitycraft$onInit(level: Internal.ClientLevel_, viewDistance: number, ci: Internal.CallbackInfo_): void;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_, $$3: boolean): Internal.LevelChunk;
        replaceWithPacketData($$0: number, $$1: number, $$2: Internal.FriendlyByteBuf_, $$3: Internal.CompoundTag_, $$4: Internal.Consumer_<Internal.ClientboundLevelChunkPacketData$BlockEntityTagOutput>): Internal.LevelChunk;
        updateViewRadius($$0: number): void;
        handler$haf000$railways$securitycraft$onDrop(x: number, z: number, ci: Internal.CallbackInfo_): void;
        storage: Internal.ClientChunkCache$Storage;
        lightEngine: Internal.LevelLightEngine;
    }
    type ClientChunkCache_ = ClientChunkCache;
    class Shulker extends Internal.AbstractGolem implements Internal.Enemy, Internal.VariantHolder<Internal.Optional<Internal.DyeColor>> {
        constructor($$0: Internal.EntityType_<Internal.Shulker>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        getColor(): Internal.DyeColor;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        getVariant(): Internal.Optional<Internal.DyeColor>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        getRenderPosition($$0: number): Internal.Optional<Vec3d>;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        static getProgressAabb($$0: Internal.Direction_, $$1: number): Internal.AABB;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getVariant(): any;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getClientPeekAmount($$0: number): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        static getProgressDeltaAabb($$0: Internal.Direction_, $$1: number, $$2: number): Internal.AABB;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getAttachFace(): Internal.Direction;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setVariant($$0: Internal.Optional_<Internal.DyeColor>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get color(): Internal.DyeColor
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get variant(): Internal.Optional<Internal.DyeColor>
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get attachFace(): Internal.Direction
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set variant($$0: Internal.Optional_<Internal.DyeColor>)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
    }
    type Shulker_ = Shulker;
    class BlockHexPressurePlate extends Internal.PressurePlateBlock {
        constructor($$0: any_, $$1: Internal.BlockBehaviour$Properties_)
        isFlammable(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFlammability(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockHexPressurePlate_ = BlockHexPressurePlate;
    interface Tickable {
        abstract tick(): void;
        (): void;
    }
    type Tickable_ = Tickable;
    class ChickenSpawnEggItem extends Internal.SpawnEggItem {
        constructor(entityType: Internal.EntityType_<Internal.Mob>, primaryColor: number, secondaryColor: number, settings: Internal.Item$Properties_, chickenData: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static getEggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get eggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ChickenSpawnEggItem_ = ChickenSpawnEggItem;
    interface IRepairKitItem extends Internal.IMaterialItem {
        canUseMaterial(mat: Internal.IMaterial_): boolean;
        emi(amount: number): Internal.EmiStack;
        canUseMaterial(mat: Internal.MaterialId_): boolean;
        abstract getMaterial(arg0: Internal.ItemStack_): Internal.MaterialVariantId;
        abstract asItem(): Internal.Item;
        withMaterialForDisplay(materialId: Internal.MaterialVariantId_): Internal.ItemStack;
        emi(): Internal.EmiStack;
        abstract getRepairAmount(): number;
        withMaterial(stack: Internal.ItemStack_, material: Internal.MaterialVariantId_): Internal.ItemStack;
        withMaterial(material: Internal.MaterialVariantId_): Internal.ItemStack;
        getMaterialFromStack(stack: Internal.ItemStack_): Internal.MaterialVariantId;
        get repairAmount(): number
    }
    type IRepairKitItem_ = IRepairKitItem;
    class TurtleVerb extends Internal.Enum<Internal.TurtleVerb> {
        static valueOf(name: string): Internal.TurtleVerb;
        static values(): Internal.TurtleVerb[];
        static readonly ATTACK: Internal.TurtleVerb;
        static readonly DIG: Internal.TurtleVerb;
    }
    type TurtleVerb_ = TurtleVerb | "dig" | "attack";
    class StationMarker {
        constructor(source: BlockPos_, target: BlockPos_, name: net.minecraft.network.chat.Component_)
        save(): Internal.CompoundTag;
        getSource(): BlockPos;
        static load(tag: Internal.CompoundTag_): Internal.StationMarker;
        getName(): net.minecraft.network.chat.Component;
        static fromWorld(level: Internal.BlockGetter_, pos: BlockPos_): Internal.StationMarker;
        getId(): string;
        getTarget(): BlockPos;
        get source(): BlockPos
        get name(): net.minecraft.network.chat.Component
        get id(): string
        get target(): BlockPos
        static readonly TYPE: Internal.MapDecoration$Type;
    }
    type StationMarker_ = StationMarker;
    class ColorAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type ColorAttribute$Type_ = ColorAttribute$Type;
    class ClientboundMoveVehiclePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_)
        getX(): number;
        handle(arg0: Internal.PacketListener_): void;
        getY(): number;
        getZ(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        getYRot(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getXRot(): number;
        isSkippable(): boolean;
        get x(): number
        get y(): number
        get z(): number
        get YRot(): number
        get XRot(): number
        get skippable(): boolean
    }
    type ClientboundMoveVehiclePacket_ = ClientboundMoveVehiclePacket;
    class ClientboundSetPassengersPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getPassengers(): number[];
        handle($$0: Internal.ClientGamePacketListener_): void;
        getVehicle(): number;
        isSkippable(): boolean;
        get passengers(): number[]
        get vehicle(): number
        get skippable(): boolean
    }
    type ClientboundSetPassengersPacket_ = ClientboundSetPassengersPacket;
    class WritableBookItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static makeSureTagIsValid($$0: Internal.CompoundTag_): boolean;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type WritableBookItem_ = WritableBookItem;
    class Stat <T> extends Internal.ObjectiveCriteria {
        getType(): Internal.StatType<T>;
        getValue(): T;
        static buildName<T>($$0: Internal.StatType_<T>, $$1: T): string;
        format($$0: number): string;
        get type(): Internal.StatType<T>
        get value(): T
    }
    type Stat_<T> = Stat<T>;
    class ConsoleLine$SourceLine extends Internal.Record {
        constructor(source: string, line: number)
        constructor(buf: Internal.FriendlyByteBuf_)
        static write(buf: Internal.FriendlyByteBuf_, sourceLine: Internal.ConsoleLine$SourceLine_): void;
        line(): number;
        source(): string;
    }
    type ConsoleLine$SourceLine_ = ConsoleLine$SourceLine;
    interface Byte2ObjectFunction <V> extends Internal.IntFunction<V>, it.unimi.dsi.fastutil.Function<number, V> {
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Byte2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        put(arg0: number, arg1: V): V;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2ObjectFunction<V>;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Byte2ObjectFunction<T>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Byte2ByteFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Byte2FloatFunction;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2ObjectFunction<V>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Byte2LongFunction;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2ObjectFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        abstract get(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        apply(arg0: number): V;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        containsKey(arg0: number): boolean;
        remove(arg0: number): V;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Byte2CharFunction;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Byte2DoubleFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        apply(arg0: number): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Byte2ReferenceFunction<T>;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2ObjectFunction<V>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2ObjectFunction<V>;
        size(): number;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        getOrDefault(arg0: number, arg1: V): V;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2ObjectFunction<V>;
        clear(): void;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Byte2IntFunction;
        defaultReturnValue(): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: number): V;
    }
    type Byte2ObjectFunction_<V> = Byte2ObjectFunction<V>;
    abstract class AbstractObject2ObjectMap <K, V> extends Internal.AbstractObject2ObjectFunction<K, V> implements Internal.Object2ObjectMap<K, V>, Internal.Serializable {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        containsValue(arg0: any): boolean;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ObjectFunction<V>;
        keySet(): Internal.Set<any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        computeIfAbsent(arg0: K, arg1: Internal.Object2ObjectFunction_<K, V>): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Object2FloatFunction<K>;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ObjectFunction<V>;
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<K, V>>;
        putIfAbsent(arg0: K, arg1: V): V;
        apply(arg0: K): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Object2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ObjectFunction<V>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Object2DoubleFunction<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ObjectFunction<V>;
        /**
         * @deprecated
        */
        computeObjectIfAbsentPartial(arg0: K, arg1: Internal.Object2ObjectFunction_<K, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Object2CharFunction<K>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        abstract defaultReturnValue(): V;
        static identity<T>(): Internal.Function<T, T>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V): V;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        isEmpty(): boolean;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ObjectFunction<V>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        put(arg0: K, arg1: V): V;
        abstract object2ObjectEntrySet(): Internal.ObjectSet<Internal.Object2ObjectMap$Entry<K, V>>;
        remove(arg0: any): V;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Object2LongFunction<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Object2IntFunction<K>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Object2ShortFunction<K>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ObjectFunction<V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ObjectFunction<T, V>;
        putAll(arg0: Internal.Map_<K, V>): void;
        values(): Internal.ObjectCollection<V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Object2ByteFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ObjectFunction<T, V>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ObjectFunction<V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Object2ObjectFunction<K, T>;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        get empty(): boolean
    }
    type AbstractObject2ObjectMap_<K, V> = AbstractObject2ObjectMap<K, V>;
    interface WorldRendererExtended {
        abstract sodium$getWorldRenderer(): Internal.SodiumWorldRenderer;
        (): Internal.SodiumWorldRenderer_;
    }
    type WorldRendererExtended_ = WorldRendererExtended;
    interface ModOrigin {
        abstract getPaths(): Internal.List<Internal.Path>;
        abstract getParentModId(): string;
        abstract getKind(): Internal.ModOrigin$Kind;
        abstract getParentSubLocation(): string;
        get paths(): Internal.List<Internal.Path>
        get parentModId(): string
        get kind(): Internal.ModOrigin$Kind
        get parentSubLocation(): string
    }
    type ModOrigin_ = ModOrigin;
    class ServerboundClientCommandPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.ServerboundClientCommandPacket$Action_)
        handle(arg0: Internal.PacketListener_): void;
        getAction(): Internal.ServerboundClientCommandPacket$Action;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        get action(): Internal.ServerboundClientCommandPacket$Action
        get skippable(): boolean
    }
    type ServerboundClientCommandPacket_ = ServerboundClientCommandPacket;
    class TankUpgradeConfig {
        constructor(builder: Internal.ForgeConfigSpec$Builder_)
        readonly capacityPerSlotRow: Internal.ForgeConfigSpec$IntValue;
        readonly autoFillDrainContainerCooldown: Internal.ForgeConfigSpec$IntValue;
        readonly stackMultiplierRatio: Internal.ForgeConfigSpec$DoubleValue;
        readonly maxInputOutput: Internal.ForgeConfigSpec$IntValue;
    }
    type TankUpgradeConfig_ = TankUpgradeConfig;
    interface Era extends Internal.TemporalAccessor, Internal.TemporalAdjuster {
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        get(arg0: Internal.TemporalField_): number;
        getLong(arg0: Internal.TemporalField_): number;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        abstract getValue(): number;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        getDisplayName(arg0: Internal.TextStyle_, arg1: Internal.Locale_): string;
        isSupported(arg0: Internal.TemporalField_): boolean;
        get value(): number
        (): number;
    }
    type Era_ = Era;
    class DiskDriveState extends Internal.Enum<Internal.DiskDriveState> implements Internal.StringRepresentable {
        static valueOf(name: string): Internal.DiskDriveState;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.DiskDriveState[];
        get serializedName(): string
        static readonly EMPTY: Internal.DiskDriveState;
        static readonly FULL: Internal.DiskDriveState;
        static readonly INVALID: Internal.DiskDriveState;
    }
    type DiskDriveState_ = "empty" | DiskDriveState | "invalid" | "full";
    class AbstractBlock <V extends Internal.IVariant<any>, B extends Internal.AbstractBlock<V, B>> extends Internal.Block implements Internal.IVariantEntry<V, B>, Internal.IBlock<V, B> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: V)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getVariant(): V;
        getCloneItemStack(world: Internal.BlockGetter_, pos: BlockPos_): Internal.ItemStack;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static box(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number): Internal.VoxelShape;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getDisplayName(stack: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockItem(properties: Internal.Item$Properties_, group: Internal.ResourceKey_<Internal.CreativeModeTab>): Internal.ItemBlock<any, any>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getContainer<T extends Internal.AbstractTileEntity<any, any>>(id: number, inventory: Internal.Inventory_, te: Internal.AbstractTileEntity_<any, any>, result: Internal.BlockHitResult_): Internal.AbstractContainer;
        getCloneItemStack(state: Internal.BlockState_, target: Internal.HitResult_, world: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_): Internal.ItemStack;
        get variant(): V
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SEMI_FULL_SHAPE: Internal.VoxelShapeSimpleCube;
    }
    type AbstractBlock_<V extends Internal.IVariant<any>, B extends Internal.AbstractBlock<V, B>> = AbstractBlock<V, B>;
    interface Palette <T> {
        abstract read(arg0: Internal.FriendlyByteBuf_): void;
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        abstract maybeHas(arg0: Internal.Predicate_<T>): boolean;
        abstract valueFor(arg0: number): T;
        abstract getSize(): number;
        abstract getSerializedSize(): number;
        abstract idFor(arg0: T): number;
        abstract copy(): this;
        get size(): number
        get serializedSize(): number
    }
    type Palette_<T> = Palette<T>;
    interface SpecialHandler$Factory <T extends Internal.SpecialHandler> {
        abstract tryMatch(arg0: Internal.HexPattern_, arg1: Internal.CastingEnvironment_): T;
        (arg0: Internal.HexPattern, arg1: Internal.CastingEnvironment): T;
    }
    type SpecialHandler$Factory_<T extends Internal.SpecialHandler> = Special.SpecialHandler | SpecialHandler$Factory<T>;
    class AgriWeed {
        constructor(mods: Internal.List_<string>, stages: Internal.List_<number>, spawnChance: number, growthChance: number, aggressive: boolean, lethal: boolean, rakeProducts: Internal.List_<any>, requirement: Internal.AgriRequirement_)
        constructor(mods: Internal.List_<string>, stages: Internal.List_<number>, spawnChance: number, growthChance: number, aggressive: boolean, lethal: boolean, rakeProducts: Internal.Optional_<Internal.List<any>>, requirement: Internal.AgriRequirement_)
        getGrowthStages(): number;
        isAggressive(): boolean;
        onRake(growthStage: Internal.AgriGrowthStage_, consumer: Internal.Consumer_<Internal.ItemStack>, random: Internal.RandomSource_, entity: Internal.LivingEntity_): void;
        isLethal(): boolean;
        getSpawnChance(crop: Internal.AgriCrop_): number;
        getGrowthChance(growthStage: Internal.AgriGrowthStage_): number;
        getInitialGrowthStage(): Internal.AgriGrowthStage;
        getWeedHeight(stage: Internal.AgriGrowthStage_): number;
        get growthStages(): number
        get aggressive(): boolean
        get lethal(): boolean
        get initialGrowthStage(): Internal.AgriGrowthStage
        static readonly CODEC: Internal.Codec<Internal.AgriWeed>;
    }
    type AgriWeed_ = Special.Weeds | AgriWeed;
    class ServerboundSetStructureBlockPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: BlockPos_, $$1: Internal.StructureBlockEntity$UpdateType_, $$2: Internal.StructureMode_, $$3: string, $$4: BlockPos_, $$5: Vec3i_, $$6: Internal.Mirror_, $$7: Internal.Rotation_, $$8: string, $$9: boolean, $$10: boolean, $$11: boolean, $$12: number, $$13: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        isIgnoreEntities(): boolean;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getData(): string;
        getSeed(): number;
        isSkippable(): boolean;
        getUpdateType(): Internal.StructureBlockEntity$UpdateType;
        getPos(): BlockPos;
        getSize(): Vec3i;
        isShowBoundingBox(): boolean;
        getRotation(): Internal.Rotation;
        isShowAir(): boolean;
        getMirror(): Internal.Mirror;
        getIntegrity(): number;
        getOffset(): BlockPos;
        getName(): string;
        getMode(): Internal.StructureMode;
        get ignoreEntities(): boolean
        get data(): string
        get seed(): number
        get skippable(): boolean
        get updateType(): Internal.StructureBlockEntity$UpdateType
        get pos(): BlockPos
        get size(): Vec3i
        get showBoundingBox(): boolean
        get rotation(): Internal.Rotation
        get showAir(): boolean
        get mirror(): Internal.Mirror
        get integrity(): number
        get offset(): BlockPos
        get name(): string
        get mode(): Internal.StructureMode
    }
    type ServerboundSetStructureBlockPacket_ = ServerboundSetStructureBlockPacket;
    abstract class EmiSequencedAssemblySubCategory {
        constructor(width: number)
        static getTooltip(recipe: Internal.SequencedRecipe_<any>, index: number): Internal.BiFunction<number, number, Internal.List<Internal.ClientTooltipComponent>>;
        getWidth(): number;
        abstract addWidgets(arg0: Internal.WidgetHolder_, arg1: number, arg2: number, arg3: Internal.SequencedRecipe_<any>, arg4: number): void;
        getAppliedIngredient(recipe: Internal.SequencedRecipe_<any>): Internal.EmiIngredient;
        get width(): number
    }
    type EmiSequencedAssemblySubCategory_ = EmiSequencedAssemblySubCategory;
    class UpgradeType <T extends Internal.IUpgradeWrapper> {
        constructor(factory: any_<T>)
        create(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>): T;
    }
    type UpgradeType_<T extends Internal.IUpgradeWrapper> = UpgradeType<T>;
    class Boat$Type extends Internal.Enum<Internal.Boat$Type> implements Internal.StringRepresentable {
        static byName($$0: string): Internal.Boat$Type;
        static values(): Internal.Boat$Type[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        getName(): string;
        static byId($$0: number): Internal.Boat$Type;
        getPlanks(): Internal.Block;
        static valueOf($$0: string): Internal.Boat$Type;
        get serializedName(): string
        get name(): string
        get planks(): Internal.Block
        static readonly DARK_OAK: Internal.Boat$Type;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Boat$Type>;
        static readonly SPRUCE: Internal.Boat$Type;
        static readonly MANGROVE: Internal.Boat$Type;
        static readonly JUNGLE: Internal.Boat$Type;
        static readonly BAMBOO: Internal.Boat$Type;
        static readonly OAK: Internal.Boat$Type;
        static readonly BIRCH: Internal.Boat$Type;
        static readonly CHERRY: Internal.Boat$Type;
        static readonly ACACIA: Internal.Boat$Type;
    }
    type Boat$Type_ = "jungle" | "bamboo" | "mangrove" | Boat$Type | "oak" | "dark_oak" | "cherry" | "acacia" | "spruce" | "birch";
    interface Spliterator$OfDouble extends Internal.Spliterator$OfPrimitive<number, Internal.DoubleConsumer, Internal.Spliterator$OfDouble> {
        forEachRemaining(arg0: any): void;
        getComparator(): Internal.Comparator<number>;
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        trySplit(): Internal.Spliterator$OfPrimitive<any, any, any>;
        getExactSizeIfKnown(): number;
        forEachRemaining(arg0: Internal.DoubleConsumer_): void;
        hasCharacteristics(arg0: number): boolean;
        tryAdvance(arg0: Internal.Consumer_<number>): boolean;
        tryAdvance(arg0: any): boolean;
        abstract characteristics(): number;
        abstract estimateSize(): number;
        abstract tryAdvance(arg0: Internal.DoubleConsumer_): boolean;
        get comparator(): Internal.Comparator<number>
        get exactSizeIfKnown(): number
    }
    type Spliterator$OfDouble_ = Spliterator$OfDouble;
    abstract class AbstractContainerScreen <T extends Internal.AbstractContainerMenu> extends Internal.Screen implements Internal.MenuAccess<T>, Internal.IMixinHandledScreen, io.wispforest.owo.mixin.ui.layers.HandledScreenAccessor, Internal.AbstractContainerScreenAccessor, net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor.AbstractContainerScreenAccessor, Internal.HandledScreenAccessor, io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.AbstractContainerScreenAccessor, dev.emi.emi.mixin.accessor.HandledScreenAccessor, Internal.AbstractContainerScreenExtension, net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor, com.simibubi.create.foundation.mixin.fabric.AbstractContainerScreenAccessor, Internal.AccessorAbstractContainerScreen, Internal.SophisticatedAbstractContainerScreen, gripe._90.polyeng.mixin.AbstractContainerScreenAccessor {
        constructor($$0: T, $$1: Internal.Inventory_, $$2: net.minecraft.network.chat.Component_)
        charTyped($$0: string, $$1: number): boolean;
        getHoveredSlot(): Internal.Slot;
        getClickedSlot(): Internal.Slot;
        drawSlotHighlightBackBig(context: Internal.GuiGraphics_): void;
        redirect$hma000$yet_another_config_lib_v3$modifyFocusCandidates(instance: Internal.ContainerEventHandler_, screenArea: Internal.ScreenRectangle_, direction: Internal.ScreenDirection_, focused: Internal.GuiEventListener_, event: Internal.FocusNavigationEvent_): Internal.List<any>;
        getY(): number;
        getGuiLeft(): number;
        setFocused($$0: boolean): void;
        sophisticatedcore_getSlotColor(slotId: number): number;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        getLeftPos(): number;
        invokeSlotClicked(arg0: Internal.Slot_, arg1: number, arg2: number, arg3: Internal.ClickType_): void;
        getImageHeight(): number;
        getBackgroundWidth(): number;
        callFindSlot(arg0: number, arg1: number): Internal.Slot;
        static getExtensions(screen: Internal.Screen_): Internal.ScreenExtensions;
        mouseMoved($$0: number, $$1: number): void;
        owo$getRootX(): number;
        getQuickCraftingType(): number;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        getDraggingItem(): Internal.ItemStack;
        isHovering($$0: Internal.Slot_, $$1: number, $$2: number): boolean;
        invokeGetSlotAt(arg0: number, arg1: number): Internal.Slot;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        clearDraggingState(): void;
        port_lib$getGuiTop(): number;
        setQuickCraftingRemainder(arg0: number): void;
        handler$beg001$balm$renderForeground(guiGraphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, partialTicks: number, callbackInfo: Internal.CallbackInfo_): void;
        getHeldButtonType(): number;
        getGuiTop(): number;
        getIsSplittingStack(): boolean;
        getDoubleclick(): boolean;
        setIsQuickCrafting(arg0: boolean): void;
        setHoveredSlot(arg0: Internal.Slot_): void;
        handler$dao000$glitchcore$onPreRenderTooltip(guiGraphics: Internal.GuiGraphics_, i: number, j: number, ci: Internal.CallbackInfo_): void;
        invokeFindSlot(arg0: number, arg1: number): Internal.Slot;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        litematica_getY(): number;
        getQuickCraftingButton(): number;
        isFocused(): boolean;
        getFocusedSlot(): Internal.Slot;
        getTouchDragStack(): Internal.ItemStack;
        port_lib$getGuiLeft(): number;
        getX(): number;
        handler$zpa000$architectury$renderForeground(graphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, delta: number, ci: Internal.CallbackInfo_): void;
        getTouchIsRightClickDrag(): boolean;
        adastra$renderPreSlot(graphics: Internal.GuiGraphics_, slot: Internal.Slot_): void;
        getTabOrderGroup(): number;
        findSlot($$0: number, $$1: number): Internal.Slot;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        static renderSlotHighlight($$0: Internal.GuiGraphics_, $$1: number, $$2: number, $$3: number): void;
        getIsQuickCrafting(): boolean;
        getLastQuickMoved(): Internal.ItemStack;
        getTouchDragSlotStart(): Internal.Slot;
        renderSlot($$0: Internal.GuiGraphics_, $$1: Internal.Slot_): void;
        getMenu(): T;
        owo$getRootY(): number;
        getQuickCraftingRemainder(): number;
        handler$zpa000$architectury$renderBackground(graphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, delta: number, ci: Internal.CallbackInfo_): void;
        getBackgroundHeight(): number;
        invokeCalculateOffset(): void;
        setSkipNextRelease(arg0: boolean): void;
        getImageWidth(): number;
        callIsHovering(arg0: Internal.Slot_, arg1: number, arg2: number): boolean;
        getXSize(): number;
        getTopPos(): number;
        getCurrentFocusPath(): Internal.ComponentPath;
        callRenderSlot(arg0: Internal.GuiGraphics_, arg1: Internal.Slot_): void;
        handler$beg001$balm$renderBackground(guiGraphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, partialTicks: number, callbackInfo: Internal.CallbackInfo_): void;
        handler$dao000$glitchcore$onPostRenderTooltip(guiGraphics: Internal.GuiGraphics_, i: number, j: number, ci: Internal.CallbackInfo_): void;
        litematica_getX(): number;
        get hoveredSlot(): Internal.Slot
        get clickedSlot(): Internal.Slot
        get y(): number
        get guiLeft(): number
        set focused($$0: boolean)
        get leftPos(): number
        get imageHeight(): number
        get backgroundWidth(): number
        get quickCraftingType(): number
        get draggingItem(): Internal.ItemStack
        set quickCraftingRemainder(arg0: number)
        get heldButtonType(): number
        get guiTop(): number
        get isSplittingStack(): boolean
        get doubleclick(): boolean
        set isQuickCrafting(arg0: boolean)
        set hoveredSlot(arg0: Internal.Slot_)
        get quickCraftingButton(): number
        get focused(): boolean
        get focusedSlot(): Internal.Slot
        get touchDragStack(): Internal.ItemStack
        get x(): number
        get touchIsRightClickDrag(): boolean
        get tabOrderGroup(): number
        get isQuickCrafting(): boolean
        get lastQuickMoved(): Internal.ItemStack
        get touchDragSlotStart(): Internal.Slot
        get menu(): T
        get quickCraftingRemainder(): number
        get backgroundHeight(): number
        set skipNextRelease(arg0: boolean)
        get imageWidth(): number
        get XSize(): number
        get topPos(): number
        get currentFocusPath(): Internal.ComponentPath
        static readonly SLOT_ITEM_BLIT_OFFSET: 100;
        hoveredSlot: Internal.Slot;
        static readonly INVENTORY_LOCATION: ResourceLocation;
        imageWidth: number;
        imageHeight: number;
        leftPos: number;
        topPos: number;
    }
    type AbstractContainerScreen_<T extends Internal.AbstractContainerMenu> = AbstractContainerScreen<T>;
    class WirelessAccessPointBlock$State extends Internal.Enum<Internal.WirelessAccessPointBlock$State> implements Internal.StringRepresentable {
        static valueOf(name: string): Internal.WirelessAccessPointBlock$State;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.WirelessAccessPointBlock$State[];
        get serializedName(): string
        static readonly OFF: Internal.WirelessAccessPointBlock$State;
        static readonly HAS_CHANNEL: Internal.WirelessAccessPointBlock$State;
        static readonly ON: Internal.WirelessAccessPointBlock$State;
    }
    type WirelessAccessPointBlock$State_ = WirelessAccessPointBlock$State | "on" | "has_channel" | "off";
    class TchotchkeItem$Companion {
        constructor($constructor_marker: any_)
        cast(user: Internal.ServerPlayer_, hand: Internal.InteractionHand_, itemStack: Internal.ItemStack_, inputs: Internal.ListIota_): void;
    }
    type TchotchkeItem$Companion_ = TchotchkeItem$Companion;
    interface Short2ShortFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntUnaryOperator {
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2ShortFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        getOrDefault(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Short2LongFunction;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Short2CharFunction;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2ShortFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Short2DoubleFunction;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        abstract get(arg0: number): number;
        identity(): this;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2ShortFunction;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2ShortFunction;
        put(arg0: number, arg1: number): number;
        apply(arg0: number): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        containsKey(arg0: number): boolean;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2ShortFunction;
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2ShortFunction;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Short2ObjectFunction<T>;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Short2IntFunction;
        size(): number;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Short2ByteFunction;
        defaultReturnValue(arg0: number): void;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Short2FloatFunction;
        clear(): void;
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2ShortFunction<T>;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2ShortFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Short2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        (arg0: number): number;
    }
    type Short2ShortFunction_ = Short2ShortFunction;
    class RealmsClient$CompatibleVersionResponse extends Internal.Enum<Internal.RealmsClient$CompatibleVersionResponse> {
        static values(): Internal.RealmsClient$CompatibleVersionResponse[];
        static valueOf($$0: string): Internal.RealmsClient$CompatibleVersionResponse;
        static readonly COMPATIBLE: Internal.RealmsClient$CompatibleVersionResponse;
        static readonly OUTDATED: Internal.RealmsClient$CompatibleVersionResponse;
        static readonly OTHER: Internal.RealmsClient$CompatibleVersionResponse;
    }
    type RealmsClient$CompatibleVersionResponse_ = "compatible" | RealmsClient$CompatibleVersionResponse | "outdated" | "other";
    class CAArmInteractions$LiquidBlazeBurnerType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type CAArmInteractions$LiquidBlazeBurnerType_ = CAArmInteractions$LiquidBlazeBurnerType;
    class IotaMultiPredicate$Any extends Internal.Record implements Internal.IotaMultiPredicate {
        constructor(needs: Internal.IotaPredicate_, fallback: Internal.IotaPredicate_)
        static either(first: Internal.IotaMultiPredicate_, second: Internal.IotaMultiPredicate_): Internal.IotaMultiPredicate;
        static triple(first: Internal.IotaPredicate_, second: Internal.IotaPredicate_, third: Internal.IotaPredicate_): Internal.IotaMultiPredicate;
        needs(): Internal.IotaPredicate;
        fallback(): Internal.IotaPredicate;
        test(iotas: Internal.Iterable_<Internal.Iota>): boolean;
        static any(needs: Internal.IotaPredicate_, fallback: Internal.IotaPredicate_): Internal.IotaMultiPredicate;
        static all(child: Internal.IotaPredicate_): Internal.IotaMultiPredicate;
        static pair(first: Internal.IotaPredicate_, second: Internal.IotaPredicate_): Internal.IotaMultiPredicate;
    }
    type IotaMultiPredicate$Any_ = IotaMultiPredicate$Any;
    class BracketBlock$BracketType extends Internal.Enum<Internal.BracketBlock$BracketType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.BracketBlock$BracketType[];
        getSerializedName(): string;
        static valueOf(name: string): Internal.BracketBlock$BracketType;
        get serializedName(): string
        static readonly SHAFT: Internal.BracketBlock$BracketType;
        static readonly PIPE: Internal.BracketBlock$BracketType;
        static readonly COG: Internal.BracketBlock$BracketType;
    }
    type BracketBlock$BracketType_ = "pipe" | "shaft" | "cog" | BracketBlock$BracketType;
    class RecipeConstructor extends Internal.Record {
        constructor(schema: Internal.RecipeSchema_, keys: Internal.RecipeKey_<any>[], factory: Internal.RecipeConstructor$Factory_)
        schema(): Internal.RecipeSchema;
        factory(): Internal.RecipeConstructor$Factory;
        keys(): Internal.RecipeKey<any>[];
    }
    type RecipeConstructor_ = RecipeConstructor;
    class LargeWaterWheelBlock extends Internal.RotatedPillarKineticBlock implements Internal.IBE<Internal.LargeWaterWheelBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getAxisForPlacement(context: Internal.BlockPlaceContext_): Internal.Direction$Axis;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.LargeWaterWheelBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.LargeWaterWheelBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getBlockEntityClass(): typeof Internal.LargeWaterWheelBlockEntity;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.LargeWaterWheelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.LargeWaterWheelBlockEntity>;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.LargeWaterWheelBlockEntity;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.LargeWaterWheelBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.LargeWaterWheelBlockEntity>
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly EXTENSION: Internal.BooleanProperty;
    }
    type LargeWaterWheelBlock_ = LargeWaterWheelBlock;
    interface StringSplitter$LinePosConsumer {
        abstract accept(arg0: Internal.Style_, arg1: number, arg2: number): void;
        (arg0: Internal.Style, arg1: number, arg2: number): void;
    }
    type StringSplitter$LinePosConsumer_ = StringSplitter$LinePosConsumer;
    interface LayoutManager {
        abstract layoutContainer(arg0: Internal.Container_): void;
        abstract preferredLayoutSize(arg0: Internal.Container_): Internal.Dimension;
        abstract minimumLayoutSize(arg0: Internal.Container_): Internal.Dimension;
        abstract removeLayoutComponent(arg0: Internal.Component_): void;
        abstract addLayoutComponent(arg0: string, arg1: Internal.Component_): void;
    }
    type LayoutManager_ = LayoutManager;
    class LootNbtProviderType extends Internal.SerializerType<any> {
        constructor($$0: Internal.Serializer_<any>)
    }
    type LootNbtProviderType_ = Special.LootNbtProviderType | LootNbtProviderType;
    interface Aquifer {
        create($$0: Internal.NoiseChunk_, $$1: Internal.ChunkPos_, $$2: Internal.NoiseRouter_, $$3: Internal.PositionalRandomFactory_, $$4: number, $$5: number, $$6: Internal.Aquifer$FluidPicker_): this;
        createDisabled($$0: Internal.Aquifer$FluidPicker_): this;
        abstract computeSubstance(arg0: Internal.DensityFunction$FunctionContext_, arg1: number): Internal.BlockState;
        abstract shouldScheduleFluidUpdate(): boolean;
    }
    type Aquifer_ = Aquifer;
    class StationSummaryDisplaySource extends Internal.DisplaySource {
        constructor()
    }
    type StationSummaryDisplaySource_ = StationSummaryDisplaySource;
    interface SignatureUpdater {
        abstract update(arg0: Internal.SignatureUpdater$Output_): void;
        (arg0: Internal.SignatureUpdater$Output): void;
    }
    type SignatureUpdater_ = SignatureUpdater;
    interface ITrackBlock {
        abstract getCurveStart(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Vec3d_): Vec3d;
        getYOffsetAt(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, end: Vec3d_): number;
        getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_, defaultMaterial: Internal.TrackMaterial_): Internal.TrackMaterial;
        abstract prepareTrackOverlay<Self extends Internal.Affine<Self>>(arg0: Internal.Affine_<Self>, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BezierTrackPointLocation_, arg5: Internal.Direction$AxisDirection_, arg6: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType_): Internal.PartialModel;
        getNearestTrackAxis(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, lookVec: Vec3d_): net.createmod.catnip.data.Pair<Vec3d, Internal.Direction$AxisDirection>;
        abstract getTrackAxes(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.List<Vec3d>;
        abstract getBogeyAnchor(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.BlockState;
        isSlope(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        abstract prepareAssemblyOverlay(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Direction_, arg4: Internal.PoseStack_): Internal.PartialModel;
        getConnected(worldIn: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, linear: boolean, connectedTo: Internal.TrackNodeLocation_): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        overlay(world: Internal.BlockGetter_, pos: BlockPos_, existing: Internal.BlockState_, placed: Internal.BlockState_): Internal.BlockState;
        getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_): Internal.TrackMaterial;
        walkConnectedTracks(worldIn: Internal.BlockGetter_, location: Internal.TrackNodeLocation_, linear: boolean): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        abstract getMaterial(): Internal.TrackMaterial;
        abstract getUpNormal(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Vec3d;
        addToListIfConnected(fromEnd: Internal.TrackNodeLocation_, list: Internal.Collection_<Internal.TrackNodeLocation$DiscoveredLocation>, offsetFactory: Internal.BiFunction_<number, boolean, Vec3d>, normalFactory: Internal.Function_<boolean, Vec3d>, dimensionFactory: Internal.Function_<boolean, Internal.ResourceKey<Internal.Level>>, yOffsetFactory: Internal.Function_<Vec3d, number>, axis: Vec3d_, viaTurn: Internal.BezierConnection_, materialFactory: Internal.BiFunction_<boolean, Vec3d, Internal.TrackMaterial>): void;
        getElevationAtCenter(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): number;
        abstract trackEquals(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        get material(): Internal.TrackMaterial
    }
    type ITrackBlock_ = ITrackBlock;
    class ValueLayouts$OfCharImpl extends Internal.ValueLayouts$AbstractValueLayout<Internal.ValueLayouts$OfCharImpl> implements Internal.ValueLayout$OfChar {
        static sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        static of(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfChar;
        static sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        withName(arg0: string): Internal.ValueLayout$OfChar;
        byteOffset(...arg0: any_[]): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        static structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfChar;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        static paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        withoutName(): Internal.ValueLayout$OfChar;
        static unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
    }
    type ValueLayouts$OfCharImpl_ = ValueLayouts$OfCharImpl;
    class WorldBorder$Settings {
        getDamagePerBlock(): number;
        getWarningBlocks(): number;
        getSizeLerpTarget(): number;
        static read($$0: Internal.DynamicLike_<any>, $$1: Internal.WorldBorder$Settings_): Internal.WorldBorder$Settings;
        getSafeZone(): number;
        getSizeLerpTime(): number;
        getSize(): number;
        getWarningTime(): number;
        getCenterZ(): number;
        write($$0: Internal.CompoundTag_): void;
        getCenterX(): number;
        get damagePerBlock(): number
        get warningBlocks(): number
        get sizeLerpTarget(): number
        get safeZone(): number
        get sizeLerpTime(): number
        get size(): number
        get warningTime(): number
        get centerZ(): number
        get centerX(): number
    }
    type WorldBorder$Settings_ = WorldBorder$Settings;
    class SemaphoreBlock extends Internal.HorizontalDirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.SemaphoreBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SemaphoreBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SemaphoreBlockEntity>): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SemaphoreBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityClass(): typeof Internal.SemaphoreBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SemaphoreBlockEntity>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SemaphoreBlockEntity;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.SemaphoreBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.SemaphoreBlockEntity>
        static readonly placementHelperId: 20;
        static readonly FULL: Internal.BooleanProperty;
        static readonly girderPlacementHelperId: 21;
        static readonly FLIPPED: Internal.BooleanProperty;
        static readonly UPSIDE_DOWN: Internal.BooleanProperty;
    }
    type SemaphoreBlock_ = SemaphoreBlock;
    /**
     * @deprecated
    */
    interface RenderAttachedBlockView extends Internal.BlockAndTintGetter {
        abstract getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
        getMinSection(): number;
        abstract getShade(arg0: Internal.Direction_, arg1: boolean): number;
        abstract getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        abstract getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        abstract getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        abstract getHeight(): number;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        canSeeSky($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        abstract getFluidState(arg0: BlockPos_): Internal.FluidState;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getSectionsCount(): number;
        abstract getMinBuildHeight(): number;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get lightEngine(): Internal.LevelLightEngine
        get height(): number
        get sectionsCount(): number
        get minBuildHeight(): number
        get maxLightLevel(): number
    }
    type RenderAttachedBlockView_ = RenderAttachedBlockView;
    class FluidConfig extends Internal.ResourceConfigValue<dev.architectury.fluid.FluidStack> {
        constructor(fixedSize: number)
        constructor(allowEmpty: boolean)
        showAmount(show: boolean): this;
        getResource(): Internal.SelectableResource<dev.architectury.fluid.FluidStack>;
        getStringForGUI(v: dev.architectury.fluid.FluidStack_): net.minecraft.network.chat.Component;
        get resource(): Internal.SelectableResource<dev.architectury.fluid.FluidStack>
    }
    type FluidConfig_ = FluidConfig;
    class FocusEvent$Cause extends Internal.Enum<Internal.FocusEvent$Cause> {
        static values(): Internal.FocusEvent$Cause[];
        static valueOf(arg0: string): Internal.FocusEvent$Cause;
        static readonly ROLLBACK: Internal.FocusEvent$Cause;
        static readonly CLEAR_GLOBAL_FOCUS_OWNER: Internal.FocusEvent$Cause;
        static readonly TRAVERSAL_UP: Internal.FocusEvent$Cause;
        static readonly TRAVERSAL_FORWARD: Internal.FocusEvent$Cause;
        static readonly UNEXPECTED: Internal.FocusEvent$Cause;
        static readonly TRAVERSAL_BACKWARD: Internal.FocusEvent$Cause;
        static readonly MOUSE_EVENT: Internal.FocusEvent$Cause;
        static readonly UNKNOWN: Internal.FocusEvent$Cause;
        static readonly TRAVERSAL: Internal.FocusEvent$Cause;
        static readonly ACTIVATION: Internal.FocusEvent$Cause;
        static readonly TRAVERSAL_DOWN: Internal.FocusEvent$Cause;
    }
    type FocusEvent$Cause_ = "traversal" | "traversal_backward" | "mouse_event" | "traversal_down" | "traversal_forward" | "rollback" | "activation" | "clear_global_focus_owner" | "unexpected" | "traversal_up" | "unknown" | FocusEvent$Cause;
    class HugeLilyPadBlock extends Internal.BushBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly QUARTER: Internal.EnumProperty<Internal.QuarterProperty>;
        static readonly FACING: Internal.DirectionProperty;
    }
    type HugeLilyPadBlock_ = HugeLilyPadBlock;
    interface SophisticatedBlockState {
        addHitEffects(level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        addDestroyEffects(level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        addRunningEffects(level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        addLandingEffects(level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
    }
    type SophisticatedBlockState_ = SophisticatedBlockState;
    class WrenchableDirectionalBlock extends Internal.DirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type WrenchableDirectionalBlock_ = WrenchableDirectionalBlock;
    class PartBuilderToolRecycle$Serializer extends Internal.LoggingRecipeSerializer<Internal.PartBuilderToolRecycle> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.PartBuilderToolRecycle;
    }
    type PartBuilderToolRecycle$Serializer_ = PartBuilderToolRecycle$Serializer;
    abstract class AENetworkInvBlockEntity extends Internal.AEBaseInvBlockEntity implements Internal.IGridConnectedBlockEntity {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        onChunkUnloaded(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onMainNodeStateChanged(reason: Internal.IGridNodeListener$State_): void;
        onLoad(): void;
        getMainNode(): Internal.IManagedGridNode;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getCableConnectionType(dir: Internal.Direction_): Internal.AECableType;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getGridConnectableSides(orientation: Internal.BlockOrientation_): Internal.Set<Internal.Direction>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get mainNode(): Internal.IManagedGridNode
        get gridNode(): Internal.IGridNode
        get actionableNode(): Internal.IGridNode
        set owner(owner: Internal.Player_)
    }
    type AENetworkInvBlockEntity_ = AENetworkInvBlockEntity;
    class AtlasPBRLoader$PBRTextureAtlasSprite extends Internal.TextureAtlasSprite {
        getBaseSprite(): Internal.TextureAtlasSprite;
        get baseSprite(): Internal.TextureAtlasSprite
    }
    type AtlasPBRLoader$PBRTextureAtlasSprite_ = AtlasPBRLoader$PBRTextureAtlasSprite;
    interface ISegmentedInventory {
        abstract getSubInventory(arg0: ResourceLocation_): Internal.InternalInventory;
        (arg0: ResourceLocation): Internal.InternalInventory_;
        readonly CONFIG: ResourceLocation;
        readonly UPGRADES: ResourceLocation;
        readonly STORAGE: ResourceLocation;
        readonly CELLS: ResourceLocation;
    }
    type ISegmentedInventory_ = ISegmentedInventory;
    class LumaloopBlock extends Internal.GrowingPlantHeadBlock {
        constructor(p_i241195_1_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        static lightLevel(level: number): Internal.ToIntFunction<Internal.BlockState>;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly LIT: Internal.BooleanProperty;
        static readonly MAX_AGE: 8;
    }
    type LumaloopBlock_ = LumaloopBlock;
    class BlockEmptyDirectrix extends Internal.BlockCircleComponent {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type BlockEmptyDirectrix_ = BlockEmptyDirectrix;
    interface JsonSerializable {
        abstract toJson(): Internal.JsonElement;
        (): Internal.JsonElement_;
    }
    type JsonSerializable_ = JsonSerializable;
    class AxisAlignedLinearPosTest extends Internal.PosRuleTest {
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Direction$Axis_)
        static readonly CODEC: Internal.Codec<Internal.AxisAlignedLinearPosTest>;
    }
    type AxisAlignedLinearPosTest_ = AxisAlignedLinearPosTest;
    class ListArithmetic implements Internal.Arithmetic {
        getOperator(pattern: Internal.HexPattern_): Internal.Operator;
        opTypes(): Internal.Iterable<Internal.HexPattern>;
        arithName(): string;
        static readonly INSTANCE: Internal.ListArithmetic;
    }
    type ListArithmetic_ = ListArithmetic;
    class ConstantFloat extends Internal.FloatProvider {
        static of($$0: number): Internal.ConstantFloat;
        getValue(): number;
        get value(): number
        static readonly ZERO: Internal.ConstantFloat;
        static readonly CODEC: Internal.Codec<Internal.ConstantFloat>;
    }
    type ConstantFloat_ = ConstantFloat;
    abstract class CompressorHolder implements Internal.Compressable {
        constructor()
        compressor<T>(arg0: Internal.DynamicOps_<T>): Internal.KeyCompressor<T>;
        abstract keys<T>(arg0: Internal.DynamicOps_<T>): Internal.Stream<T>;
        static forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
    }
    type CompressorHolder_ = CompressorHolder;
    class ItemTypeIota$1 extends Internal.IotaType<Internal.ItemTypeIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.ItemTypeIota;
    }
    type ItemTypeIota$1_ = ItemTypeIota$1;
    class SpellList$SpellListIterator implements Internal.Iterator<Internal.Iota>, Internal.KMappedMarker {
        constructor(list: Internal.SpellList_)
        forEachRemaining(arg0: Internal.Consumer_<Internal.Iota>): void;
        remove(): void;
        getList(): Internal.SpellList;
        next(): any;
        hasNext(): boolean;
        setList(<set-?>: Internal.SpellList_): void;
        get list(): Internal.SpellList
        set list(<set-?>: Internal.SpellList_)
    }
    type SpellList$SpellListIterator_ = SpellList$SpellListIterator;
    interface MetadataSectionSerializer <T> {
        abstract getMetadataSectionName(): string;
        abstract fromJson(arg0: Internal.JsonObject_): T;
        get metadataSectionName(): string
    }
    type MetadataSectionSerializer_<T> = MetadataSectionSerializer<T>;
    interface OpticFinder <FT> {
        abstract type(): com.mojang.datafixers.types.Type<FT>;
        inField<GT>(arg0: string, arg1: com.mojang.datafixers.types.Type_<GT>): this;
        abstract findType<A, FR>(arg0: com.mojang.datafixers.types.Type_<A>, arg1: com.mojang.datafixers.types.Type_<FR>, arg2: boolean): Internal.Either<Internal.TypedOptic<A, any, FT, FR>, Internal.Type$FieldNotFoundException>;
        findType<A>(arg0: com.mojang.datafixers.types.Type_<A>, arg1: boolean): Internal.Either<Internal.TypedOptic<A, any, FT, FT>, Internal.Type$FieldNotFoundException>;
    }
    type OpticFinder_<FT> = OpticFinder<FT>;
    class OverslimeModifierRecipe implements Internal.IDisplayModifierRecipe, Internal.ITinkerStationRecipe {
        constructor(id: ResourceLocation_, ingredient: Internal.Ingredient_, restoreAmount: number)
        getGroup(): string;
        getValidatedResult(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ValidatedResult;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        getRemainingItems(inv: Internal.ITinkerStationContainer_): Internal.NonNullList<Internal.ItemStack>;
        getDisplayItems(slot: number): Internal.List<Internal.ItemStack>;
        matches(inv: Internal.ITinkerStationContainer_, world: Internal.Level_): boolean;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        updateInputs(result: Internal.ItemStack_, inv: Internal.IMutableTinkerStationContainer_, isServer: boolean): void;
        getToolWithoutModifier(): Internal.List<Internal.ItemStack>;
        getSlots(): Internal.SlotType$SlotCount;
        getSlotType(): Internal.SlotType;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        isIncremental(): boolean;
        getToolWithModifier(): Internal.List<Internal.ItemStack>;
        getMod(): string;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_): Internal.ItemStack;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getDisplayResult(): Internal.ModifierEntry;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        getMaxLevel(): number;
        shrinkToolSlotBy(): number;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        getInputCount(): number;
        assemble(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_, persistentDataConsumer: Internal.Consumer_<Internal.ModDataNBT>): Internal.ItemStack;
        isIncomplete(): boolean;
        getRequirementsError(): string;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        hasRequirements(): boolean;
        getModifier(): Internal.Modifier;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get toolWithoutModifier(): Internal.List<Internal.ItemStack>
        get slots(): Internal.SlotType$SlotCount
        get slotType(): Internal.SlotType
        get incremental(): boolean
        get toolWithModifier(): Internal.List<Internal.ItemStack>
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get displayResult(): Internal.ModifierEntry
        get maxLevel(): number
        get type(): ResourceLocation
        get inputCount(): number
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get requirementsError(): string
        get modifier(): Internal.Modifier
    }
    type OverslimeModifierRecipe_ = OverslimeModifierRecipe;
    class RangedAttribute extends Internal.Attribute implements Internal.AccessorRangedAttribute {
        constructor($$0: string, $$1: number, $$2: number, $$3: number)
        getMinValue(): number;
        attributefix$setMaxValue(arg0: number): void;
        attributefix$setMinValue(arg0: number): void;
        getMaxValue(): number;
        get minValue(): number
        get maxValue(): number
    }
    type RangedAttribute_ = RangedAttribute | Special.Attribute;
    interface SchematicPrinter$PlacementPredicate {
        abstract shouldPlace(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.BlockEntity_, arg3: Internal.BlockState_, arg4: Internal.BlockState_, arg5: boolean): boolean;
        (arg0: BlockPos, arg1: Internal.BlockState, arg2: Internal.BlockEntity, arg3: Internal.BlockState, arg4: Internal.BlockState, arg5: boolean): boolean;
    }
    type SchematicPrinter$PlacementPredicate_ = SchematicPrinter$PlacementPredicate;
    interface VertexBufferWriter {
        tryOf(consumer: Internal.VertexConsumer_): this;
        canUseIntrinsics(): boolean;
        abstract push(arg0: Internal.MemoryStack_, arg1: number, arg2: number, arg3: Internal.VertexFormatDescription_): void;
        of(consumer: Internal.VertexConsumer_): this;
        copyInto(writer: Internal.VertexBufferWriter_, stack: Internal.MemoryStack_, ptr: number, count: number, format: Internal.VertexFormatDescription_): void;
        (arg0: Internal.MemoryStack, arg1: number, arg2: number, arg3: Internal.VertexFormatDescription): void;
    }
    type VertexBufferWriter_ = VertexBufferWriter;
    interface AEKeyFilter {
        abstract matches(arg0: Internal.AEKey_): boolean;
        none(): this;
        (arg0: Internal.AEKey): boolean;
    }
    type AEKeyFilter_ = AEKeyFilter;
    class Collections$UnmodifiableList <E> extends Internal.Collections$UnmodifiableCollection<E> implements Internal.List<E> {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        addLast(arg0: E): void;
        get(arg0: number): E;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getLast(): E;
        listIterator(): Internal.ListIterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeFirst(): E;
        sort(arg0: Internal.Comparator_<E>): void;
        set(arg0: number, arg1: E): E;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        reversed(): Internal.SequencedCollection<any>;
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        remove(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        subList(arg0: number, arg1: number): Internal.List<E>;
        indexOf(arg0: any): number;
        addFirst(arg0: E): void;
        add(arg0: number, arg1: E): void;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<E>;
        getFirst(): E;
        abstract iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        lastIndexOf(arg0: any): number;
        get last(): E
        get first(): E
    }
    type Collections$UnmodifiableList_<E> = Collections$UnmodifiableList<E>;
    class GenericCrossingBlock extends Internal.Block implements Internal.ProperWaterloggedBlock, Internal.ITrackBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.GenericCrossingBlockEntity>, Internal.SpecialBlockItemRequirement {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_, defaultMaterial: Internal.TrackMaterial_): Internal.TrackMaterial;
        getNearestTrackAxis(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, lookVec: Vec3d_): net.createmod.catnip.data.Pair<Vec3d, Internal.Direction$AxisDirection>;
        getTrackAxes(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): Internal.List<Vec3d>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.GenericCrossingBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRequiredItems(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        getBogeyAnchor(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): Internal.BlockState;
        isSlope(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getMaterial(): Internal.TrackMaterial;
        getUpNormal(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): Vec3d;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityClass(): typeof Internal.GenericCrossingBlockEntity;
        getElevationAtCenter(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): number;
        trackEquals(state1: Internal.BlockState_, state2: Internal.BlockState_): boolean;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.GenericCrossingBlockEntity>): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        prepareTrackOverlay<Self extends Internal.Affine<Self>>(affine: Internal.Affine_<Self>, blockGetter: Internal.BlockGetter_, blockPos: BlockPos_, blockState: Internal.BlockState_, bezierTrackPointLocation: Internal.BezierTrackPointLocation_, axisDirection: Internal.Direction$AxisDirection_, renderedTrackOverlayType: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType_): Internal.PartialModel;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.GenericCrossingBlockEntity>;
        setDestroySpeed(v: number): void;
        prepareAssemblyOverlay(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, direction: Internal.Direction_, ms: Internal.PoseStack_): Internal.PartialModel;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        getConnected(worldIn: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, linear: boolean, connectedTo: Internal.TrackNodeLocation_): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_): Internal.TrackMaterial;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static walkConnectedTracks(worldIn: Internal.BlockGetter_, location: Internal.TrackNodeLocation_, linear: boolean): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getCurveStart(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, axis: Vec3d_): Vec3d;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getYOffsetAt(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, end: Vec3d_): number;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        overlay(world: Internal.BlockGetter_, pos: BlockPos_, existing: Internal.BlockState_, placed: Internal.BlockState_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.GenericCrossingBlockEntity>;
        emi(amount: number): Internal.EmiStack;
        static addToListIfConnected(fromEnd: Internal.TrackNodeLocation_, list: Internal.Collection_<Internal.TrackNodeLocation$DiscoveredLocation>, offsetFactory: Internal.BiFunction_<number, boolean, Vec3d>, normalFactory: Internal.Function_<boolean, Vec3d>, dimensionFactory: Internal.Function_<boolean, Internal.ResourceKey<Internal.Level>>, yOffsetFactory: Internal.Function_<Vec3d, number>, axis: Vec3d_, viaTurn: Internal.BezierConnection_, materialFactory: Internal.BiFunction_<boolean, Vec3d, Internal.TrackMaterial>): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.GenericCrossingBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get material(): Internal.TrackMaterial
        set lightEmission(v: number)
        get blockEntityClass(): typeof Internal.GenericCrossingBlockEntity
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.GenericCrossingBlockEntity>
        static readonly SHAPE: Internal.EnumProperty<Internal.TrackShape>;
    }
    type GenericCrossingBlock_ = GenericCrossingBlock;
    interface ReadWriteLock {
        abstract writeLock(): Internal.Lock;
        abstract readLock(): Internal.Lock;
    }
    type ReadWriteLock_ = ReadWriteLock;
    class EntityEvents$Size extends Internal.EntityEvents {
        constructor(entity: Internal.Entity_, pose: Internal.Pose_, oldSize: Internal.EntityDimensions_, newSize: Internal.EntityDimensions_, oldEyeHeight: number, newEyeHeight: number)
        constructor(entity: Internal.Entity_, pose: Internal.Pose_, size: Internal.EntityDimensions_, defaultEyeHeight: number)
        setNewSize(size: Internal.EntityDimensions_): void;
        getPose(): Internal.Pose;
        setNewEyeHeight(newHeight: number): void;
        getOldEyeHeight(): number;
        getOldSize(): Internal.EntityDimensions;
        getNewSize(): Internal.EntityDimensions;
        setNewSize(size: Internal.EntityDimensions_, updateEyeHeight: boolean): void;
        getNewEyeHeight(): number;
        set newSize(size: Internal.EntityDimensions_)
        get pose(): Internal.Pose
        set newEyeHeight(newHeight: number)
        get oldEyeHeight(): number
        get oldSize(): Internal.EntityDimensions
        get newSize(): Internal.EntityDimensions
        get newEyeHeight(): number
    }
    type EntityEvents$Size_ = EntityEvents$Size;
    class SeaPickleFeature extends Internal.Feature<Internal.CountConfiguration> {
        constructor($$0: Internal.Codec_<Internal.CountConfiguration>)
    }
    type SeaPickleFeature_ = SeaPickleFeature;
    class AgriFluidCondition$Builder {
        constructor()
        build(): Internal.AgriFluidCondition;
        states(...states: string[]): this;
        tag(namespace: string, path: string): this;
        fluid(location: string): this;
        fluid(namespace: string, path: string): this;
        tag(location: string): this;
    }
    type AgriFluidCondition$Builder_ = AgriFluidCondition$Builder;
    class PlatformWrapper$ModInfo {
        constructor(i: string)
        getCustomName(): string;
        setName(n: string): void;
        getName(): string;
        getVersion(): string;
        getId(): string;
        get customName(): string
        set name(n: string)
        get name(): string
        get version(): string
        get id(): string
    }
    type PlatformWrapper$ModInfo_ = PlatformWrapper$ModInfo;
    class ChestBlock extends Internal.AbstractChestBlock<Internal.ChestBlockEntity> implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.Supplier_<Internal.BlockEntityType<Internal.ChestBlockEntity>>)
        static isChestBlockedAt($$0: Internal.LevelAccessor_, $$1: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static getBlockType($$0: Internal.BlockState_): Internal.DoubleBlockCombiner$BlockType;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static opennessCombiner($$0: Internal.LidBlockEntity_): Internal.DoubleBlockCombiner$Combiner<Internal.ChestBlockEntity, Internal.Float2FloatFunction>;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static getContainer($$0: Internal.ChestBlock_, $$1: Internal.BlockState_, $$2: Internal.Level_, $$3: BlockPos_, $$4: boolean): net.minecraft.world.Container;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        blockEntityType(): Internal.BlockEntityType<Internal.ChestBlockEntity>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        static getConnectedDirection($$0: Internal.BlockState_): Internal.Direction;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly EVENT_SET_OPEN_COUNT: 1;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly TYPE: Internal.EnumProperty<Internal.ChestType>;
        static readonly FACING: Internal.DirectionProperty;
    }
    type ChestBlock_ = ChestBlock;
    class PatternProviderLogic implements Internal.ICraftingProvider, Internal.InternalInventoryHost {
        constructor(mainNode: Internal.IManagedGridNode_, host: Internal.PatternProviderLogicHost_)
        constructor(mainNode: Internal.IManagedGridNode_, host: Internal.PatternProviderLogicHost_, patternInventorySize: number)
        saveChanges(): void;
        isBlocking(): boolean;
        getPatternPriority(): number;
        addDrops(drops: Internal.List_<Internal.ItemStack>): void;
        exportSettings(output: Internal.CompoundTag_): void;
        getConfigManager(): Internal.IConfigManager;
        writeToNBT(tag: Internal.CompoundTag_): void;
        getReturnInv(): Internal.PatternProviderReturnInventory;
        updateRedstoneState(): void;
        onMainNodeStateChanged(): void;
        updatePatterns(): void;
        getTerminalGroup(): Internal.PatternContainerGroup;
        getGrid(): Internal.IGrid;
        getCraftingLockedReason(): Internal.LockCraftingMode;
        resetCraftingLock(): void;
        getPatternInv(): Internal.InternalInventory;
        isBusy(): boolean;
        readFromNBT(tag: Internal.CompoundTag_): void;
        isClientSide(): boolean;
        importSettings(input: Internal.CompoundTag_, player: Internal.Player_): void;
        pushPattern(patternDetails: Internal.IPatternDetails_, inputHolder: Internal.KeyCounter_[]): boolean;
        getAvailablePatterns(): Internal.List<Internal.IPatternDetails>;
        getSortValue(): number;
        setPriority(priority: number): void;
        getUnlockStack(): Internal.GenericStack;
        getPriority(): number;
        static requestUpdate(managedNode: Internal.IManagedGridNode_): void;
        getEmitableItems(): Internal.Set<Internal.AEKey>;
        onChangeInventory(inv: Internal.InternalInventory_, slot: number): void;
        clearContent(): void;
        get blocking(): boolean
        get patternPriority(): number
        get configManager(): Internal.IConfigManager
        get returnInv(): Internal.PatternProviderReturnInventory
        get terminalGroup(): Internal.PatternContainerGroup
        get grid(): Internal.IGrid
        get craftingLockedReason(): Internal.LockCraftingMode
        get patternInv(): Internal.InternalInventory
        get busy(): boolean
        get clientSide(): boolean
        get availablePatterns(): Internal.List<Internal.IPatternDetails>
        get sortValue(): number
        set priority(priority: number)
        get unlockStack(): Internal.GenericStack
        get priority(): number
        get emitableItems(): Internal.Set<Internal.AEKey>
        static readonly NBT_UNLOCK_STACK: "unlockStack";
        static readonly NBT_UNLOCK_EVENT: "unlockEvent";
        static readonly NBT_PRIORITY: "priority";
        static readonly NBT_RETURN_INV: "returnInv";
        static readonly NBT_SEND_LIST: "sendList";
        static readonly NBT_SEND_DIRECTION: "sendDirection";
        static readonly NBT_MEMORY_CARD_PATTERNS: "patterns";
    }
    type PatternProviderLogic_ = PatternProviderLogic;
    class OxygenDistributorBlock extends Internal.SidedMachineBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly SOUTH_SIDE_SHAPE: Internal.ArrayVoxelShape;
        static readonly TOP_SHAPE: Internal.ArrayVoxelShape;
        static readonly EAST_SIDE_SHAPE: Internal.ArrayVoxelShape;
        static readonly WEST_SIDE_SHAPE: Internal.ArrayVoxelShape;
        static readonly NORTH_SIDE_SHAPE: Internal.ArrayVoxelShape;
        static readonly BOTTOM_SHAPE: Internal.ArrayVoxelShape;
    }
    type OxygenDistributorBlock_ = OxygenDistributorBlock;
    class InvisibleMonoBogeyBlock extends Internal.AbstractMonoBogeyBlock<Internal.InvisibleMonoBogeyBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.InvisibleMonoBogeyBlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.InvisibleMonoBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.InvisibleMonoBogeyBlockEntity>): void;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getBlockEntityClass(): typeof Internal.InvisibleMonoBogeyBlockEntity;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.InvisibleMonoBogeyBlockEntity>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.InvisibleMonoBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.InvisibleMonoBogeyBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.InvisibleMonoBogeyBlockEntity
        set destroySpeed(v: number)
    }
    type InvisibleMonoBogeyBlock_ = InvisibleMonoBogeyBlock;
    interface PigmentItem {
        abstract provideColor(arg0: Internal.ItemStack_, arg1: Internal.UUID_): Internal.ColorProvider;
        (arg0: Internal.ItemStack, arg1: Internal.UUID): Internal.ColorProvider_;
    }
    type PigmentItem_ = PigmentItem;
    interface BehaviorControl <E extends Internal.LivingEntity> {
        abstract tryStart(arg0: Internal.ServerLevel_, arg1: E, arg2: number): boolean;
        abstract debugString(): string;
        abstract doStop(arg0: Internal.ServerLevel_, arg1: E, arg2: number): void;
        abstract getStatus(): Internal.Behavior$Status;
        abstract tickOrStop(arg0: Internal.ServerLevel_, arg1: E, arg2: number): void;
        get status(): Internal.Behavior$Status
    }
    type BehaviorControl_<E extends Internal.LivingEntity> = BehaviorControl<E>;
    class Schedule {
        constructor()
        getActivityAt($$0: number): Internal.Activity;
        static readonly VILLAGER_DEFAULT: Internal.Schedule;
        static readonly SIMPLE: Internal.Schedule;
        static readonly EMPTY: Internal.Schedule;
        static readonly WORK_START_TIME: 2000;
        static readonly VILLAGER_BABY: Internal.Schedule;
        static readonly TOTAL_WORK_TIME: 7000;
    }
    type Schedule_ = Schedule | Special.Schedule;
    class MapDecoration$Type extends Internal.Enum<Internal.MapDecoration$Type> {
        isRenderedOnFrame(): boolean;
        getMapColor(): number;
        static values(): Internal.MapDecoration$Type[];
        hasMapColor(): boolean;
        shouldTrackCount(): boolean;
        static byIcon($$0: number): Internal.MapDecoration$Type;
        getIcon(): number;
        static valueOf($$0: string): Internal.MapDecoration$Type;
        get renderedOnFrame(): boolean
        get mapColor(): number
        get icon(): number
        static readonly BANNER_GREEN: Internal.MapDecoration$Type;
        static readonly BANNER_RED: Internal.MapDecoration$Type;
        static readonly BANNER_GRAY: Internal.MapDecoration$Type;
        static readonly MANSION: Internal.MapDecoration$Type;
        static readonly BANNER_BLUE: Internal.MapDecoration$Type;
        static readonly MONUMENT: Internal.MapDecoration$Type;
        static readonly PLAYER_OFF_LIMITS: Internal.MapDecoration$Type;
        static readonly TARGET_POINT: Internal.MapDecoration$Type;
        static readonly BANNER_LIGHT_BLUE: Internal.MapDecoration$Type;
        static readonly RED_X: Internal.MapDecoration$Type;
        static readonly BANNER_MAGENTA: Internal.MapDecoration$Type;
        static readonly BLUE_MARKER: Internal.MapDecoration$Type;
        static readonly BANNER_WHITE: Internal.MapDecoration$Type;
        static readonly PLAYER_OFF_MAP: Internal.MapDecoration$Type;
        static readonly BANNER_LIGHT_GRAY: Internal.MapDecoration$Type;
        static readonly BANNER_YELLOW: Internal.MapDecoration$Type;
        static readonly TARGET_X: Internal.MapDecoration$Type;
        static readonly RED_MARKER: Internal.MapDecoration$Type;
        static readonly BANNER_ORANGE: Internal.MapDecoration$Type;
        static readonly BANNER_BLACK: Internal.MapDecoration$Type;
        static readonly BANNER_BROWN: Internal.MapDecoration$Type;
        static readonly BANNER_PURPLE: Internal.MapDecoration$Type;
        static readonly PLAYER: Internal.MapDecoration$Type;
        static readonly BANNER_LIME: Internal.MapDecoration$Type;
        static readonly BANNER_PINK: Internal.MapDecoration$Type;
        static readonly FRAME: Internal.MapDecoration$Type;
        static readonly BANNER_CYAN: Internal.MapDecoration$Type;
    }
    type MapDecoration$Type_ = "banner_blue" | "player" | "banner_black" | "banner_cyan" | MapDecoration$Type | "banner_gray" | "target_x" | "monument" | "banner_brown" | "banner_light_blue" | "banner_white" | "banner_purple" | "banner_lime" | "banner_yellow" | "banner_pink" | "red_x" | "frame" | "red_marker" | "player_off_limits" | "banner_magenta" | "player_off_map" | "blue_marker" | "banner_red" | "banner_orange" | "target_point" | "banner_light_gray" | "mansion" | "banner_green";
    class IndustrialLampBlock extends Internal.FaceAttachedHorizontalDirectionalBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly UP_SHAPE_Z: Internal.ArrayVoxelShape;
        static readonly EAST_SHAPE: Internal.ArrayVoxelShape;
        static readonly UP_SHAPE_X: Internal.ArrayVoxelShape;
        static readonly SOUTH_SHAPE: Internal.ArrayVoxelShape;
        static readonly WEST_SHAPE: Internal.ArrayVoxelShape;
        static readonly DOWN_SHAPE_X: Internal.ArrayVoxelShape;
        static readonly NORTH_SHAPE: Internal.ArrayVoxelShape;
        static readonly DOWN_SHAPE_Z: Internal.ArrayVoxelShape;
    }
    type IndustrialLampBlock_ = IndustrialLampBlock;
    interface PotatoProjectileRenderMode {
        abstract codec(): Internal.Codec<Internal.PotatoProjectileRenderMode>;
        abstract transform(arg0: Internal.PoseStack_, arg1: Internal.PotatoProjectileEntity_, arg2: number): void;
        readonly CODEC: Internal.Codec<Internal.PotatoProjectileRenderMode>;
    }
    type PotatoProjectileRenderMode_ = PotatoProjectileRenderMode;
    class WrappedGoal extends Internal.Goal {
        constructor($$0: number, $$1: Internal.Goal_)
        isRunning(): boolean;
        canBeReplacedBy($$0: Internal.WrappedGoal_): boolean;
        getGoal(): Internal.Goal;
        getPriority(): number;
        get running(): boolean
        get goal(): Internal.Goal
        get priority(): number
    }
    type WrappedGoal_ = WrappedGoal;
    class HarvesterBlockEntity extends Internal.CachedRenderBBBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setAnimatedSpeed(speed: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getAnimatedSpeed(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        set animatedSpeed(speed: number)
        get animatedSpeed(): number
        get infiniteBoundingBox(): Internal.AABB
    }
    type HarvesterBlockEntity_ = HarvesterBlockEntity;
    class ClientboundDamageEventPacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Optional_<Vec3d>)
        constructor($$0: Internal.Entity_, $$1: DamageSource_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        sourcePosition(): Internal.Optional<Vec3d>;
        handle($$0: Internal.ClientGamePacketListener_): void;
        sourceDirectId(): number;
        sourceTypeId(): number;
        entityId(): number;
        sourceCauseId(): number;
        isSkippable(): boolean;
        getSource($$0: Internal.Level_): DamageSource;
        get skippable(): boolean
    }
    type ClientboundDamageEventPacket_ = ClientboundDamageEventPacket;
}
declare namespace me.jellysquid.mods.sodium.mixin.features.textures.animations.upload {
    interface SpriteContentsAccessor {
        abstract getImages(): Internal.NativeImage[];
        get images(): Internal.NativeImage[]
        (): Internal.NativeImage_[];
    }
    type SpriteContentsAccessor_ = SpriteContentsAccessor;
}
declare namespace dev.kosmx.playerAnim.core.impl {
    class AnimationProcessor {
        constructor(animation: Internal.IAnimation_)
        getFirstPersonMode(): Internal.FirstPersonMode;
        setTickDelta(tickDelta: number): void;
        getBend(modelName: string): Internal.Pair<number, number>;
        isActive(): boolean;
        isFirstPersonAnimationDisabled(): boolean;
        get3DTransform(modelName: string, type: Internal.TransformType_, value0: Internal.Vec3f_): Internal.Vec3f;
        tick(): void;
        getFirstPersonConfiguration(): Internal.FirstPersonConfiguration;
        get firstPersonMode(): Internal.FirstPersonMode
        set tickDelta(tickDelta: number)
        get active(): boolean
        get firstPersonAnimationDisabled(): boolean
        get firstPersonConfiguration(): Internal.FirstPersonConfiguration
    }
    type AnimationProcessor_ = AnimationProcessor;
}
declare namespace dev.architectury.fluid {
    class FluidStack {
        setTag(tag: Internal.CompoundTag_): void;
        getRawFluid(): Internal.Fluid;
        getOrCreateChildTag(childName: string): Internal.CompoundTag;
        static read(tag: Internal.CompoundTag_): dev.architectury.fluid.FluidStack;
        removeChildTag(childName: string): void;
        isFluidStackEqual(other: dev.architectury.fluid.FluidStack_): boolean;
        isEmpty(): boolean;
        copy(): this;
        static create(fluid: Internal.Supplier_<Internal.Fluid>, amount: number, tag: Internal.CompoundTag_): dev.architectury.fluid.FluidStack;
        getAmount(): number;
        isTagEqual(other: dev.architectury.fluid.FluidStack_): boolean;
        write(tag: Internal.CompoundTag_): Internal.CompoundTag;
        static create(fluid: Internal.Fluid_, amount: number): dev.architectury.fluid.FluidStack;
        static empty(): dev.architectury.fluid.FluidStack;
        static create(fluid: Internal.Supplier_<Internal.Fluid>, amount: number): dev.architectury.fluid.FluidStack;
        write(buf: Internal.FriendlyByteBuf_): void;
        isFluidEqual(other: dev.architectury.fluid.FluidStack_): boolean;
        getName(): net.minecraft.network.chat.Component;
        static init(): void;
        static create(fluid: Internal.Fluid_, amount: number, tag: Internal.CompoundTag_): dev.architectury.fluid.FluidStack;
        getRawFluidSupplier(): Internal.Supplier<Internal.Fluid>;
        static read(buf: Internal.FriendlyByteBuf_): dev.architectury.fluid.FluidStack;
        getTranslationKey(): string;
        setAmount(amount: number): void;
        shrink(amount: number): void;
        getOrCreateTag(): Internal.CompoundTag;
        grow(amount: number): void;
        getChildTag(childName: string): Internal.CompoundTag;
        hasTag(): boolean;
        static bucketAmount(): number;
        getTag(): Internal.CompoundTag;
        getFluid(): Internal.Fluid;
        static create(stack: dev.architectury.fluid.FluidStack_, amount: number): dev.architectury.fluid.FluidStack;
        copyWithAmount(amount: number): this;
        set tag(tag: Internal.CompoundTag_)
        get rawFluid(): Internal.Fluid
        get empty(): boolean
        get amount(): number
        get name(): net.minecraft.network.chat.Component
        get rawFluidSupplier(): Internal.Supplier<Internal.Fluid>
        get translationKey(): string
        set amount(amount: number)
        get orCreateTag(): Internal.CompoundTag
        get tag(): Internal.CompoundTag
        get fluid(): Internal.Fluid
    }
    type FluidStack_ = FluidStack;
}
declare namespace net.p3pp3rf1y.sophisticatedbackpacks.mixin.common.accessor {
    interface SmithingTransformRecipeAccessor {
        abstract getResult(): Internal.ItemStack;
        abstract getTemplate(): Internal.Ingredient;
        abstract getBase(): Internal.Ingredient;
        abstract getAddition(): Internal.Ingredient;
        get result(): Internal.ItemStack
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get addition(): Internal.Ingredient
    }
    type SmithingTransformRecipeAccessor_ = SmithingTransformRecipeAccessor;
}
declare namespace appeng.block.networking {
    class ControllerBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly CONTROLLER_TYPE: Internal.EnumProperty<Internal.ControllerBlock$ControllerRenderType>;
        static readonly CONTROLLER_STATE: Internal.EnumProperty<Internal.ControllerBlock$ControllerBlockState>;
    }
    type ControllerBlock_ = ControllerBlock;
}
declare namespace net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor {
    interface AbstractContainerScreenAccessor {
        abstract getDraggingItem(): Internal.ItemStack;
        abstract getHoveredSlot(): Internal.Slot;
        abstract getClickedSlot(): Internal.Slot;
        abstract setQuickCraftingRemainder(arg0: number): void;
        abstract getGuiLeft(): number;
        abstract callIsHovering(arg0: Internal.Slot_, arg1: number, arg2: number): boolean;
        abstract getXSize(): number;
        abstract getGuiTop(): number;
        abstract getIsSplittingStack(): boolean;
        abstract getDoubleclick(): boolean;
        abstract getLastQuickMoved(): Internal.ItemStack;
        abstract setHoveredSlot(arg0: Internal.Slot_): void;
        abstract getQuickCraftingType(): number;
        abstract getQuickCraftingRemainder(): number;
        get draggingItem(): Internal.ItemStack
        get hoveredSlot(): Internal.Slot
        get clickedSlot(): Internal.Slot
        set quickCraftingRemainder(arg0: number)
        get guiLeft(): number
        get XSize(): number
        get guiTop(): number
        get isSplittingStack(): boolean
        get doubleclick(): boolean
        get lastQuickMoved(): Internal.ItemStack
        set hoveredSlot(arg0: Internal.Slot_)
        get quickCraftingType(): number
        get quickCraftingRemainder(): number
    }
    type AbstractContainerScreenAccessor_ = AbstractContainerScreenAccessor;
}
declare namespace net.fabricmc.fabric.api.renderer.v1.material {
    class BlendMode extends Internal.Enum<net.fabricmc.fabric.api.renderer.v1.material.BlendMode> {
        static valueOf(name: string): net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        static fromRenderLayer(renderLayer: Internal.RenderType_): net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        static values(): net.fabricmc.fabric.api.renderer.v1.material.BlendMode[];
        static readonly DEFAULT: net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        static readonly CUTOUT_MIPPED: net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        static readonly TRANSLUCENT: net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        static readonly SOLID: net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        static readonly CUTOUT: net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        readonly blockRenderLayer: Internal.RenderType;
    }
    type BlendMode_ = "translucent" | BlendMode | "solid" | "cutout" | "default" | "cutout_mipped";
}
